//
//  UIViewLayout.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 17.02.23.
//

import UIKit

extension UIView {
    
    @discardableResult
    func anchor(top: NSLayoutYAxisAnchor?, leading: NSLayoutXAxisAnchor?, bottom: NSLayoutYAxisAnchor?, trailing: NSLayoutXAxisAnchor?, padding: UIEdgeInsets = .zero, size: CGSize = .zero) -> AnchoredConstraints {
        
        translatesAutoresizingMaskIntoConstraints = false
        var anchoredConstraints = AnchoredConstraints()
        
        if let top = top {
            anchoredConstraints.top = topAnchor.constraint(equalTo: top, constant: padding.top)
        }
        
        if let leading = leading {
            anchoredConstraints.leading = leadingAnchor.constraint(equalTo: leading, constant: padding.left)
        }
        
        if let bottom = bottom {
            anchoredConstraints.bottom = bottomAnchor.constraint(equalTo: bottom, constant: -padding.bottom)
        }
        
        if let trailing = trailing {
            anchoredConstraints.trailing = trailingAnchor.constraint(equalTo: trailing, constant: -padding.right)
        }
        
        if size.width != 0 {
            anchoredConstraints.width = widthAnchor.constraint(equalToConstant: size.width)
        }
        
        if size.height != 0 {
            anchoredConstraints.height = heightAnchor.constraint(equalToConstant: size.height)
        }
        
        [anchoredConstraints.top, anchoredConstraints.leading, anchoredConstraints.bottom, anchoredConstraints.trailing, anchoredConstraints.width, anchoredConstraints.height].forEach{ $0?.isActive = true }
        
        return anchoredConstraints
    }
    
    func fillSuperview(padding: UIEdgeInsets = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewTopAnchor = superview?.topAnchor {
            topAnchor.constraint(equalTo: superviewTopAnchor, constant: padding.top).isActive = true
        }
        
        if let superviewBottomAnchor = superview?.bottomAnchor {
            bottomAnchor.constraint(equalTo: superviewBottomAnchor, constant: -padding.bottom).isActive = true
        }
        
        if let superviewLeadingAnchor = superview?.leadingAnchor {
            leadingAnchor.constraint(equalTo: superviewLeadingAnchor, constant: padding.left).isActive = true
        }
        
        if let superviewTrailingAnchor = superview?.trailingAnchor {
            trailingAnchor.constraint(equalTo: superviewTrailingAnchor, constant: -padding.right).isActive = true
        }
    }
    
    func centerInSuperview(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    

    func centerInSuperviewDeveloperModePINLabel(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewLeadingAnchor = superview?.leadingAnchor {
            leadingAnchor.constraint(equalTo: superviewLeadingAnchor, constant: 20).isActive = true
        }
        
        if let superviewTopAnchor = superview?.topAnchor {
            topAnchor.constraint(equalTo: superviewTopAnchor, constant: 0).isActive = true
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewDeveloperModePasswordStackView(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewLeadingAnchor = superview?.leadingAnchor {
            leadingAnchor.constraint(equalTo: superviewLeadingAnchor, constant: 20).isActive = true
        }
        
        if let superviewTopAnchor = superview?.topAnchor {
            topAnchor.constraint(equalTo: superviewTopAnchor, constant: 20).isActive = true
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    

    func centerInSuperviewLoginText(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 60)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    
    func centerInSuperviewFooterText(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 10)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    //bottomAnchor.constraint(equalTo: superview!.bottomAnchor, constant: -20).isActive = true
    
    func centerInSuperviewAppLogo(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.topAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
            topAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -20)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewAPPPINTextLabel(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -55)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    
    func centerInSuperviewTest(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -100)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPassword(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -130)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPINFieldDigi1(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: -75)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -30)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPINFieldDigi2(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: -45)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -30)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPINFieldDigi3(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: -15)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -30)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPINFieldDigi4(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: +15)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -30)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPINFieldDigi5(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: +45)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -30)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewPINFieldDigi6(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: +75)])
        }
        
        if let superviewCenterYAnchor = superview?.bottomAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
                bottomAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -30)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperview2(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor).isActive = true
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            //centerYAnchor.constraint(equalTo: superviewCenterYAnchor).isActive = true
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: -25)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    
    func centerInSuperviewDigit1(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: -100)])
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 150)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewDigit2(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: -60)])
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 150)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewDigit3(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: -20)])
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 150)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewDigit4(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: 20)])
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 150)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewDigit5(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: 60)])
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 150)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    func centerInSuperviewDigit6(size: CGSize = .zero) {
        translatesAutoresizingMaskIntoConstraints = false
        if let superviewCenterXAnchor = superview?.centerXAnchor {
            NSLayoutConstraint.activate([
            centerXAnchor.constraint(equalTo: superviewCenterXAnchor, constant: 100)])
        }
        
        if let superviewCenterYAnchor = superview?.centerYAnchor {
            NSLayoutConstraint.activate([
            centerYAnchor.constraint(equalTo: superviewCenterYAnchor, constant: 150)])
        }
        
        if size.width != 0 {
            widthAnchor.constraint(equalToConstant: size.width).isActive = true
        }
        
        if size.height != 0 {
            heightAnchor.constraint(equalToConstant: size.height).isActive = true
        }
    }
    
    
    func centerXInSuperview() {
        translatesAutoresizingMaskIntoConstraints = false
        if let superViewCenterXAnchor = superview?.centerXAnchor {
            centerXAnchor.constraint(equalTo: superViewCenterXAnchor).isActive = true
        }
    }
    
    func centerYInSuperview() {
        translatesAutoresizingMaskIntoConstraints = false
        if let centerY = superview?.centerYAnchor {
            centerYAnchor.constraint(equalTo: centerY).isActive = true
        }
    }
    
    func constrainWidth(constant: CGFloat) {
        translatesAutoresizingMaskIntoConstraints = false
        widthAnchor.constraint(equalToConstant: constant).isActive = true
    }
    
    func constrainHeight(constant: CGFloat) {
        translatesAutoresizingMaskIntoConstraints = false
        heightAnchor.constraint(equalToConstant: constant).isActive = true
    }
}

struct AnchoredConstraints {
    var top, leading, bottom, trailing, width, height: NSLayoutConstraint?
}
